-- Aby móc uruchomić ten przykład, upewnij się najpierw, że 
-- uruchomiłeś wcześniej SalesOrdersStructure.sql i
-- SalesOrdersData.sql w katalogu z bazami przykładowymi 

ALTER SESSION SET CURRENT_SCHEMA = SalesOrdersSample;

-- Listing 8.3 Wyświetlanie wszystkich klientów i wszystkich produktów, z oznaczeniem które produkty zostały zamówione przez klienta
SELECT CustProd.CustomerID, CustProd.CustFirstName, CustProd.CustLastName,
  CustProd.ProductNumber, CustProd.ProductName, 
  (CASE WHEN OrdDet.OrderCount > 0 
    THEN 'Zakupiłeś to!'
    ELSE ' ' 
  END) ProductOrdered
FROM
(SELECT C.CustomerID, C.CustFirstName, C.CustLastName,
  P.ProductNumber, P.ProductName, P.ProductDescription
FROM Customers C, Products P) CustProd
LEFT JOIN
(SELECT O.CustomerID, OD.ProductNumber, Count(*) AS OrderCount
FROM Orders O INNER JOIN Order_Details OD
  ON O.OrderNumber = OD.OrderNumber
GROUP BY O.CustomerID, OD.ProductNumber) OrdDet
  ON CustProd.CustomerID = OrdDet.CustomerID
  AND CustProd.ProductNumber = OrdDet.ProductNumber
ORDER BY CustProd.CustomerID, CustProd.ProductName;
